---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-Taint Evictionコントローラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/tainteviction/taint_eviction.go` - コントローラー本体
- E-02: `pkg/controller/tainteviction/timed_workers.go` - TimedWorkerQueue
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NodeUpdateChannelSize = 10 | E-01 (55行目) | ○ |
| C-02 | UpdateWorkerSize = 8 | E-01 (57行目) | ○ |
| C-03 | podUpdateChannelSize = 1 | E-01 (58行目) | ○ |
| C-04 | Pod削除リトライ5回 | E-01 (59行目, 116行目) | ○ |
| C-05 | FNV-1aハッシュでワーカー分散 | E-01 (72-76行目) | ○ |
| C-06 | getNoExecuteTaintsでNoExecuteのみ抽出 | E-01 (150-158行目) | ○ |
| C-07 | getMinTolerationTimeで最小許容時間計算 | E-01 (161-182行目) | ○ |
| C-08 | ノード更新優先処理 | E-01 (357-386行目) | ○ |
| C-09 | DisruptionTarget条件をPod削除前に設定 | E-01 (129-148行目) | ○ |
| C-10 | Reason=DeletionByTaintManager | E-01 (139行目) | ○ |
| C-11 | taintedNodesマップで状態管理 | E-01 (97-98行目) | ○ |
| C-12 | kubectl taintとの関連 | E-03 (48行目) | ○ |
| C-13 | processPodOnNodeが退避判定の中核 | E-01 (451-490行目) | ○ |
| C-14 | handleNodeUpdateで全Pod評価 | E-01 (533-588行目) | ○ |
| C-15 | 同一ワーカーでNode/Pod処理によりレース回避 | E-01 (334-337行目コメント) | ○ |
| C-16 | TimedWorkerQueueで時間指定退避 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] processPodOnNodeの退避判定ロジックがソースコードと一致するか
- [ ] ノード更新優先処理の記述が正確か
- [ ] メトリクス名（PodDeletionsTotal等）が正確か
